using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using ORDEREDUNITCOMMENT = gov.va.med.vbecs.Common.VbecsTables.OrderedUnitComment;

namespace gov.va.med.vbecs.BOL
{

	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/16/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Specimen business object class</summary>

	#endregion

	public class OrderedUnitComment:BaseBusinessObject
	{
		#region constructors
		
		
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2261"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>OrderedUnitComment object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2272"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// OrderedUnitComment
		/// </summary>
		public OrderedUnitComment()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		#endregion


		#region variables

		private Guid _orderedUnitCommentGUID;
		private Guid _orderedUnitGUID;
		//private int _cannedCommentID;
		private Guid _cannedCommentGUID;
		private string _orderedUnitCommentText;

		#endregion


		#region properties
		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2273"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2287"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// OrderedUnitCommentGuid
		/// </summary>
		public Guid OrderedUnitCommentGuid
		{
			get
			{
				return _orderedUnitCommentGUID;
			}
			set
			{
				this._orderedUnitCommentGUID = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2288"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2317"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// OrderedUnitGuid
		/// </summary>
		public Guid OrderedUnitGuid
		{
			get
			{
				return _orderedUnitGUID;
			}
			set
			{
				this._orderedUnitGUID = value;
			}
		}



		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2318"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>OrderedUnitComment object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2386"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets or sets Canned Comment unique identifier
		/// </summary>
		public Guid CannedCommentGuid
		{
			get
			{
				return _cannedCommentGUID;
			}
			set
			{
				this._cannedCommentGUID = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2424"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2464"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// OrderedUnitCommentText
		/// </summary>
		public string OrderedUnitCommentText
		{
			get
			{
				return _orderedUnitCommentText;
			}
			set
			{
				this._orderedUnitCommentText = value;
			}
		}

		#endregion


		#region methods
		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2465"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2479"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// InitializeBlankOrderedUnitCommentTable
		/// </summary>
		/// <returns></returns>
		public static DataTable InitializeBlankOrderedUnitCommentTable()
		{
			DataTable dtOrderedUnitComment = new DataTable();
			dtOrderedUnitComment.Columns.Add(ORDEREDUNITCOMMENT.OrderedUnitCommentGuid, typeof(Guid));
			dtOrderedUnitComment.Columns.Add(ORDEREDUNITCOMMENT.OrderedUnitGuid, typeof(Guid));
			//dtOrderedUnitComment.Columns.Add(ORDEREDUNITCOMMENT.CannedCommentID, typeof(int));
			dtOrderedUnitComment.Columns.Add(ORDEREDUNITCOMMENT.CannedCommentGuid, typeof(Guid));
			dtOrderedUnitComment.Columns.Add(ORDEREDUNITCOMMENT.OrderedUnitCommentText, typeof(string));
			dtOrderedUnitComment.Columns.Add(ORDEREDUNITCOMMENT.LastUpdateUser, typeof(string));
			return dtOrderedUnitComment;
		}
		
		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dtRow">dtRow</param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			this._orderedUnitCommentGUID	= dtRow.IsNull(ORDEREDUNITCOMMENT.OrderedUnitCommentGuid) ? Guid.Empty : (Guid) dtRow[ORDEREDUNITCOMMENT.OrderedUnitCommentGuid];
			this._orderedUnitGUID			= dtRow.IsNull(ORDEREDUNITCOMMENT.OrderedUnitGuid) ? Guid.Empty : (Guid) dtRow[ORDEREDUNITCOMMENT.OrderedUnitGuid];
			//this._cannedCommentID			= dtRow.IsNull(ORDEREDUNITCOMMENT.CannedCommentID) ? int.MinValue : (int) dtRow[ORDEREDUNITCOMMENT.CannedCommentID];
			this._cannedCommentGUID			= dtRow.IsNull(ORDEREDUNITCOMMENT.CannedCommentGuid) ? Guid.Empty : (Guid) dtRow[ORDEREDUNITCOMMENT.CannedCommentGuid];
			this._orderedUnitCommentText	= dtRow.IsNull(ORDEREDUNITCOMMENT.OrderedUnitCommentText) ? string.Empty : (string) dtRow[ORDEREDUNITCOMMENT.OrderedUnitCommentText];
			this.IsDirty = false;
			this.IsNew = false;
		}
		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2481"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2493"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// LoadDataRowFromThis
		/// </summary>
		/// <param name="dtRow">dtRow</param>
		/// <returns></returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			return dtRow;
		}




		#endregion

	}
}
